<?php
// index.php
// Ensure your framework/bootstrapping code runs before this file if needed.
// This file assumes helper functions site_config() and base_url() are available in scope.
?><!doctype html>
<html lang="bn">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <title>Ready to take payments using <?= htmlspecialchars(site_config("site_name")) ?></title>

  <!-- Google Fonts -->
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;600;700;800&family=Poppins:wght@400;600;700&display=swap" rel="stylesheet">

  <!-- Bootstrap 5 (CDN) -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">

  <!-- Font Awesome (CDN) -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">

  <style>
    /* ===== GLOBAL ===== */
    :root{
      --accent-1: #6c47ff;
      --accent-2: #a700ff;
      --glass-bg: rgba(255,255,255,0.65);
      --muted: #adb5bd;
      --card-radius: 18px;
    }
    *{box-sizing:border-box}
    body{
      font-family: "Inter","Poppins",system-ui,-apple-system,Segoe UI, Roboto, "Helvetica Neue", Arial;
      margin:0;
      background: linear-gradient(180deg,#f4f6fb 0%, #eef2ff 100%);
      color:#222;
      -webkit-font-smoothing:antialiased;
      -moz-osx-font-smoothing:grayscale;
    }

    /* ===== HEADER HERO ===== */
    .page-header{
      position:relative;
      padding:72px 0 60px;
      color: #fff;
      overflow:hidden;
      border-bottom-left-radius: 36px;
      border-bottom-right-radius: 36px;
      background: radial-gradient(1200px 400px at 10% 10%, rgba(255,255,255,0.06), transparent 10%),
                  linear-gradient(135deg, var(--accent-1) 0%, var(--accent-2) 100%);
    }
    .page-header .page-heading{
      font-size: clamp(26px, 4vw, 44px);
      font-weight:800;
      letter-spacing: -0.6px;
      margin-bottom: 8px;
    }
    .page-header .page-intro{
      color: rgba(255,255,255,0.92);
      font-size: clamp(14px, 1.6vw, 18px);
      margin-bottom:18px;
    }

    /* search box */
    .main-search-box .search-form{
      max-width:640px;
      margin:0 auto;
      display:flex;
      gap:10px;
      align-items:center;
    }
    .search-input{
      flex:1;
      border-radius:999px;
      padding:10px 18px;
      border:none;
      font-size:15px;
      outline:none;
      box-shadow: 0 6px 22px rgba(11,8,36,0.25), inset 0 1px 0 rgba(255,255,255,0.12);
      background: rgba(255,255,255,0.12);
      color:#fff;
      transition: all 200ms ease;
    }
    .search-input::placeholder{ color: rgba(255,255,255,0.85) }
    .search-btn{
      border-radius:999px;
      padding:10px 18px;
      border:none;
      background: rgba(255,255,255,0.12);
      color:#fff;
      font-weight:700;
      box-shadow:none;
      transition: transform .18s ease, background .18s ease;
    }
    .search-btn:hover{ transform:translateY(-3px); background: rgba(255,255,255,0.18) }

    /* ===== CARDS ===== */
    .docs-overview .card{
      border: none;
      border-radius: var(--card-radius);
      background: linear-gradient(180deg, rgba(255,255,255,0.90), rgba(255,255,255,0.82));
      padding:18px;
      transition: transform .28s cubic-bezier(.2,.9,.28,1), box-shadow .28s;
      box-shadow: 0 8px 26px rgba(31,20,80,0.06);
    }
    .docs-overview .card:hover{
      transform: translateY(-10px) scale(1.01);
      box-shadow: 0 30px 70px rgba(31,20,80,0.12);
    }
    .card .card-title{
      display:flex;
      align-items:center;
      gap:12px;
      margin-bottom:8px;
    }
    .theme-icon-holder{
      width:48px;
      height:48px;
      display:inline-flex;
      align-items:center;
      justify-content:center;
      border-radius:12px;
      background: linear-gradient(180deg, rgba(108,71,255,0.12), rgba(167,0,255,0.08));
      box-shadow: inset 0 -6px 18px rgba(108,71,255,0.03);
    }
    .card-title-text{ font-weight:700; font-size:18px; color:#141429 }

    .card-text{ color:#58607a; font-size:14.5px; line-height:1.5; }

    .card-link-mask{ position:absolute; inset:0; border-radius:inherit; z-index:0; text-indent:-9999px; }

    /* ===== CTA ===== */
    .cta-section{
      padding:48px 0;
      color:#fff;
      margin-top:32px;
      border-top-left-radius: 28px;
      border-top-right-radius: 28px;
      background: linear-gradient(170deg, rgba(12,10,48,0.96), rgba(12,40,80,0.95));
    }
    .cta-section h3{ font-size:28px; font-weight:800 }
    .cta-section .section-intro{ color: rgba(255,255,255,0.9); max-width:760px; margin:0 auto 18px; font-size:15px }

    .btn-soft{
      display:inline-flex;
      align-items:center;
      gap:10px;
      background: linear-gradient(90deg, rgba(255,255,255,0.95), rgba(255,255,255,0.92));
      color: var(--accent-2);
      padding:10px 20px;
      border-radius:999px;
      font-weight:700;
      text-decoration:none;
      transition: transform .18s ease, box-shadow .18s ease;
    }
    .btn-soft:hover{ transform:translateY(-6px); box-shadow: 0 22px 50px rgba(12,10,48,0.18) }

    /* ===== SMALL TOUCHES ===== */
    .container .row > [class*="col-"]{ position: relative; }
    .theme-bg-shapes-left, .theme-bg-shapes-right{
      position:absolute;
      width:280px;height:280px;
      border-radius:48%;
      filter: blur(40px);
      opacity:0.16;
      z-index:0;
    }
    .theme-bg-shapes-left{ left:-60px; top:10px; background: radial-gradient(circle at 30% 30%, rgba(255,255,255,0.25), transparent 30%); }
    .theme-bg-shapes-right{ right:-60px; bottom:-30px; background: radial-gradient(circle at 70% 70%, rgba(255,255,255,0.14), transparent 30%); }

    /* responsive spacing */
    @media (max-width:767px){
      .page-header{ padding:48px 12px 40px }
      .docs-overview { padding-bottom: 8px; }
      .page-header .page-heading{ font-size:28px }
      .theme-bg-shapes-left, .theme-bg-shapes-right{ display:none }
    }
  </style>
</head>
<body>

  <div class="docs-wrapper">

    <header class="page-header text-center position-relative">
      <div class="theme-bg-shapes-right"></div>
      <div class="theme-bg-shapes-left"></div>
      <div class="container position-relative" style="z-index:2">
        <h1 class="page-heading single-col-max mx-auto">Ready to take payments using <?= htmlspecialchars(site_config("site_name")) ?></h1>
        <p class="page-intro single-col-max mx-auto">Accept payments from <?= htmlspecialchars(site_config("site_name")) ?> customer accounts using our rich APIs and secure payment gateway.</p>

        <div class="main-search-box pt-3 d-block mx-auto">
          <form class="search-form w-100" action="<?= base_url('developers/docs') ?>" method="get" role="search" aria-label="Search docs">
            <input type="text" placeholder="Search the docs..." name="search" class="form-control search-input" aria-label="Search the docs">
            <button type="submit" class="btn search-btn" value="Search" aria-label="Submit search"><i class="fas fa-search"></i></button>
          </form>
        </div>
      </div>
    </header><!--//page-header-->

    <main class="page-content">
      <section class="container">
        <div class="docs-overview py-5">
          <div class="row justify-content-center g-4">

            <div class="col-12 col-md-6 col-lg-4">
              <div class="card h-100">
                <div class="card-body position-relative">
                  <h5 class="card-title mb-3">
                    <span class="theme-icon-holder card-icon-holder me-2">
                      <i class="fas fa-map-signs"></i>
                    </span>
                    <span class="card-title-text">Introduction</span>
                  </h5>
                  <p class="card-text"><?= htmlspecialchars(site_config("site_name")) ?> Payment Gateway enables merchants to receive money from customers by temporarily redirecting them to www.<?= htmlspecialchars(site_config("site_name")) ?>.com in a secure, PCI-aligned flow.</p>
                  <a class="card-link-mask" href="<?= base_url('developers/docs') ?>#section-1">Introduction</a>
                </div>
              </div>
            </div>

            <div class="col-12 col-md-6 col-lg-4">
              <div class="card h-100">
                <div class="card-body position-relative">
                  <h5 class="card-title mb-3">
                    <span class="theme-icon-holder card-icon-holder me-2">
                      <i class="fas fa-key"></i>
                    </span>
                    <span class="card-title-text">APIs</span>
                  </h5>
                  <p class="card-text">REST APIs are supported in Sandbox and Live environments. Use the Sandbox for testing and move to Live with your production API keys when ready.</p>
                  <a class="card-link-mask" href="<?= base_url('developers/docs') ?>#section-2">APIs</a>
                </div>
              </div>
            </div>

            <div class="col-12 col-md-6 col-lg-4">
              <div class="card h-100">
                <div class="card-body position-relative">
                  <h5 class="card-title mb-3">
                    <span class="theme-icon-holder card-icon-holder me-2">
                      <i class="fas fa-cogs fa-fw"></i>
                    </span>
                    <span class="card-title-text">Integration</span>
                  </h5>
                  <p class="card-text">Integrate our gateway into PHP, Laravel, WordPress, WooCommerce and other platforms. We provide sample code and SDKs to speed up integration.</p>
                  <a class="card-link-mask" href="<?= base_url('developers/docs') ?>#section-3">Integration</a>
                </div>
              </div>
            </div>

            <div class="col-12 col-md-6 col-lg-4">
              <div class="card h-100">
                <div class="card-body position-relative">
                  <h5 class="card-title mb-3">
                    <span class="theme-icon-holder card-icon-holder me-2">
                      <i class="fas fa-mobile-alt"></i>
                    </span>
                    <span class="card-title-text">Mobile App</span>
                  </h5>
                  <p class="card-text">Download our Android mobile app and connect with live API keys to verify and monitor transactions in real time.</p>
                  <a class="card-link-mask" href="<?= base_url('developers/docs') ?>#section-5">Mobile App</a>
                </div>
              </div>
            </div>

            <!-- Extra feature card, optional -->
            <div class="col-12 col-md-6 col-lg-4">
              <div class="card h-100">
                <div class="card-body position-relative">
                  <h5 class="card-title mb-3">
                    <span class="theme-icon-holder card-icon-holder me-2">
                      <i class="fas fa-shield-alt"></i>
                    </span>
                    <span class="card-title-text">Security & Compliance</span>
                  </h5>
                  <p class="card-text">Our platform follows industry best-practices: tokenization, TLS, secure storage and audit-ready logs. Detailed compliance docs are available.</p>
                  <a class="card-link-mask" href="<?= base_url('developers/docs') ?>#section-security">Security</a>
                </div>
              </div>
            </div>

          </div><!--//row-->
        </div><!--//docs-overview-->
      </section>
    </main>

    <section class="cta-section text-center">
      <div class="container">
        <h3 class="mb-2">Ready to take payments using <?= htmlspecialchars(site_config("site_name")) ?>?</h3>
        <div class="section-intro mb-3">Accept payments from <?= htmlspecialchars(site_config("site_name")) ?> customer account using our rich, secure online payment gateway APIs — well-structured and enterprise-ready.</div>
        <div class="pt-3">
          <a class="btn-soft" href="<?= base_url() ?>" target="_blank" rel="noopener">
            Get <?= htmlspecialchars(site_config("site_name")) ?>
            <i class="fas fa-arrow-alt-circle-right" style="opacity:.9"></i>
          </a>
        </div>
      </div>
    </section>

  </div><!--//docs-wrapper-->

  <!-- Optional JS: Bootstrap bundle -->
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>

  <!-- Small UX enhancement: subtle entrance animation -->
  <script>
    document.addEventListener('DOMContentLoaded', function(){
      requestAnimationFrame(() => {
        document.querySelectorAll('.card').forEach((el, i) => {
          el.style.transitionDelay = (i * 40) + 'ms';
          el.style.opacity = 0;
          el.style.transform = 'translateY(18px)';
        });
        setTimeout(() => {
          document.querySelectorAll('.card').forEach((el) => {
            el.style.opacity = 1;
            el.style.transform = 'translateY(0)';
          });
        }, 120);
      });
    });
  </script>
</body>
</html>
